	function [iext,iextm] = removeiext(iext,iextm)

	% Forcing part of the algorithm needs ncoe+1 extreme points as starting
	% values. Extra extreme points are located and removed to keep that
	% amount right.
	
	% <---------------------------------------------------------------<< DH <<<
	% SYM_WDF.m -> linremez.m -> newgrid.m
	%                          -> iextnew.m
	%                          -> forcing.m -> forcehelp.m -> phas.m
	%                          -> phas.m
	%                          -> removeiext.m
	%            -> factors.m
	% <---------------------------------------------------------------<< DH <<<

% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Tapio Saramaki, 2018-03-10
	% 	Modified by: 	 
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	tapio.saramaki@tut.fi
	
	
	% <--- edited Jan-29-2007 with MATLAB R2006a ---------------------<< DH <<<
	
	stopr = 0;i = 1;
	while(stopr == 0)
		if (i == length(iext))
			stopr = 1;
		else
			if (sign(iextm(i)) == sign(iextm(i+1)))
				if (abs(iextm(i)) > abs(iextm(i+1)))
					iext = [iext(1:i) iext(i+2:end)];    % two consecutive with same
					iextm = [iextm(1:i) iextm(i+2:end)]; % sign, remove lower one
				else
					iext = [iext(1:i-1) iext(i+1:end)];
					iextm = [iextm(1:i-1) iextm(i+1:end)];
				end
			else
				i = i+1;
			end
		end        
	end
 
